	[G, Z, P] = CH_I_POLES_Z(Wc, Ws, Amax, Amin, N)
	
	
	% 	Computes the denormalized poles, zeros, and gain constant for  
	%	a digital lowpass Chevyshev I filter.  
	%	The design margin is used to decrease the stopband edge.
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, 2010-10-08
	% 	Modified by: 	
	% 	Version: 		1
	% 	Known bugs:
	% 	Copyright:		by authors - not released for commercial use	
	% 	Report bugs to:	Wanhammar@gmail.com

	% N must be an integer
	
	if ~(abs(N-round(N)) < eps)
		error('N must be an integeer')  
		return
	end
	wac = tan(wcT/2);
	was = tan(wsT/2);
	[G, Z, P] = CH_I_POLES_S(wac, was, Amax, Amin, N);
	[G, Z, P] = PZ_2_PZ_Z(G, Z, P, 2);

